<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TicketAvailability extends Model 
{

    protected $table = 'ticket_availabilities';
    public $timestamps = true;
    protected $fillable = array('trip_id', 'seat_class_id', 'ticket_class_id', 'pax', 'seat_from', 'seat_to');

    public function trip()
    {
        return $this->belongsTo('App\Models\Trip');
    }

    public function ticketClass()
    {
        return $this->belongsTo('App\Models\TicketClass');
    }

    public function seatClass()
    {
        return $this->belongsTo('App\Models\SeatClass');
    }

    public function cabinType()
    {
        return $this->belongsTo('App\Models\CabinType');
    }

}